﻿(function ($) {
    //Override ui.menu methods needed for autocomplete to work 
    $.widget("ui.menu", $.ui.menu, {
        _move: function (direction, filter, event) {
            var next;
            if (this.active) {
                if (direction === "first" || direction === "last") {
                    next = this.active[direction === "first" ? "prevAll" : "nextAll"](".ui-menu-item").eq(-1);
                } else {
                    next = this.active[direction + "All"](".ui-menu-item").eq(0);
                }
            }
            if (!next || !next.length || !this.active) {
                next = this.activeMenu.find("> .ui-menu-item")[filter]();
            }

            this.focus(event, next);
        }
    });
}(jQuery));

(function ($) {
    var autoCompleteSharedData = [];

    $.widget("a4.a4autocomplete", {
        options: {
            ajaxAction: undefined,
            ajaxParams: {},
            ajaxInitialData: null,
            ajaxExcludeData: null,
            data: undefined,
            valueProperty: "Value",
            labelProperty: "Label",
            descriptionProperty: "Desc",
            categoryProperty: undefined,
            tooltipProperty: undefined,
            defaultValue: "",
            defaultLabel: "",
            tooltipData: undefined,
            tooltipCustomStyle: undefined,
            tooltipCustomPosition: undefined,
            sortData: false,
            validateSelection: true,
            multipleSelection: false,
            displayMultipleSelectionAsList: false,
            displayDropDownButton: true,
            resources: [],
            valueSeparator: ",",
            displaySeparator: null,
            displayDeleteItem: false,
            maxItems: null,
            limitResults: 100,
            altValueField: undefined, //Input element that is to be updated with the selected value from the autocomplete.
            altValueSeperator: ",",
            appendToParent: true, //For use inside modal dialogs (Doesn't work with IE)
            hideSelectedItems: false, //Hide selected items in suggestion box
            required: false, //Auto select item if there's no value
            render: {
                item: undefined,
                selected: undefined
            },
            boxWidth: undefined,
            defaultValueWhenInvalid: false,
            multiSelectCustomValidationValues: null
            /*  This multiSelectCustomValidationValues property is used for restricting multiselectfield to have single select and multiselect at the same
                For using this assing singleselectoption like multiSelectCustomValidationValues: { "singleselectoption": ['1', '2']}. If singleselectoption have any value and 
                that value is already selected then it will restrict multiselect from selecting any.
                singleselecterrormessage property must be set to show errormessage on selection of any other single select if one is already selected.
            */
        },
        _getMultiSelectionFieldValues: function () {
            return this.wrapper.find(".selected-item").map(function () {
                return $(this).attr("data-value");
            }).get();
        },
        _customValidationForMultiSelect: function (item) {
            var validationPassed = true;
            var customValidationOptions = this.options.multiSelectCustomValidationValues;
            
            if (customValidationOptions && customValidationOptions.singleselectoption) {
                var isSingleSelectOption = customValidationOptions.singleselectoption.indexOf(item.Value) > -1;
                var otherSingleSelectIsAlreadySelected = false;
                var values = this._getMultiSelectionFieldValues();

                if (values) {
                    values.forEach(function (a) {
                        if (customValidationOptions.singleselectoption.indexOf(a) > -1) {
                            otherSingleSelectIsAlreadySelected = true;
                        }
                    });
                }

                if (otherSingleSelectIsAlreadySelected) { //One single select is already there then restricting others
                    validationPassed = false;
                }
                else if (isSingleSelectOption && values.length > 0) {//Multiple values already selected then not allwing single select
                    validationPassed = false;
                }
            }
            return validationPassed;
        },
        _create: function () {
            var self = this;
            var autocomplete = this.element;

            // Wrap autocomplete with a div, if it's not done yet
            if (autocomplete.closest(".autocomplete-container").length == 0) {
                autocomplete.wrap("<div class='autocomplete-container'></div>");
                autocomplete.wrap("<div class='autocomplete-input'></div>");
            }

            this.wrapper = autocomplete.closest(".autocomplete-container");

            if (this.options.multipleSelection) {
                this._initializeMultiple();
            }

            var placeHolder = this._getLabel("PlaceHolder");

            if (placeHolder)
                autocomplete.attr("placeholder", placeHolder);

            //Prevents autocomplete to trigger a change if a select was already triggered
            this.preventSelect = false;
            this.isOpen = false;

            var source = this._getSource();

            if (source) {
                autocomplete.autocomplete({
                    source: source,
                    minLength: 1,
                    delay: 100,
                    change: function (event, ui) {
                        if (!self.preventSelect) {
                            self._selectItem(self._getAutoCompleteItem(ui));
                        }
                    },
                    select: function (event, ui) {
                        self.preventSelect = true;

                        self._selectItem(self._getAutoCompleteItem(ui));
                        autocomplete.trigger("change");

                        if (self.options.maxItems && self.options.maxItems == self.getSelectedItemsCount()) {
                            self.toggle(true, true);
                        }

                        if (event)
                            event.preventDefault();
                    },
                    open: function () {
                        autocomplete.addClass("autocomplete-open");
                        self.isOpen = true;
                    },
                    close: function () {
                        //IE focus hack
                        autocomplete.autocomplete("option", "minLength", 1);
                        autocomplete.removeClass("autocomplete-open");
                        self.isOpen = false;
                        self._hideTooltip();
                    },
                    search: function (event, ui) {
                        self._trigger("search", event, {});
                    }
                }).on("blur", function () {
                    self.preventSelect = false;
                    self._hideTooltip();
                });

                //Append autocomplete box to parent document, if it's inside a dialog
                if (!a4.ie() && this.options.appendToParent && autocomplete.closest(".modernEditor").length > 0 && a4.inIFrame(autocomplete)) {
                    this._setModalDialogOptions();
                }

                this._updateRendering();

                this._resolveInitialValue();

                if (this.options.displayDropDownButton) {
                    this._createButton();
                }

                var autocompleteIcons = $("<span />", { "class": "autocomplete-icon" });

                autocompleteIcons.append(voxco.icons.getIcon("loading", "autocomplete-loading"));
                autocompleteIcons.append(voxco.icons.getIcon("warning", "autocomplete-error"));

                autocomplete.before(autocompleteIcons);

                $(".icon", autocompleteIcons).hide();

                this._initializeTooltip();
            }

            this._bindEvents();

            //Set autocomplete to disabled if input is disabled
            if (this.element.is(":disabled") || this.element.prop("readOnly")) {
                $(".h-autocomplete-button", this.wrapper).addClass("disabled");

                if (this.options.multipleSelection) {
                    $(".selected-item", this.wrapper).addClass("disabled");
                    $(".selected-item .remove-item", this.wrapper).addClass("disabled");
                }
            }

            //To disable browser autofill feature
            this.element.attr("autocomplete", "off");

            this._trigger("create");
        },
        _getSourceDataKey: function () {
            var args = {};
            for (var key in this.options.ajaxParams) {
                if (this.options.ajaxParams.hasOwnProperty(key))
                    args[key] = _.result(this.options.ajaxParams, key);
            }

            return this.options.ajaxAction.replace(/\//g, "_") + _.values(args).join("_");
        },
        _getSource: function () {
            var self = this;
            var autocomplete = this.element;

            var data = this.options.data;
            var ajaxAction = this.options.ajaxAction;
            var ajaxParams = this.options.ajaxParams;
            var ajaxInitialData = this.options.ajaxInitialData;
            var ajaxExcludeData = this.options.ajaxExcludeData;
            var sortData = this.options.sortData;
            var source;

            if (data) {
                if (sortData) {
                    data = self._sortData(data);
                }

                source = function (request, response) {
                    response(self._findItems(data, request.term));
                }
            }
            else if (ajaxAction) {
                source = function (request, response) {
                    var dataKey = self._getSourceDataKey();

                    if (!autoCompleteSharedData[dataKey]) {
                        $(".autocomplete-icon .autocomplete-loading", self.wrapper).show();
                        a4.callServerMethod(ajaxAction, ajaxParams, function (result) {
                            $(".autocomplete-icon .autocomplete-loading", self.wrapper).hide();

                            if (result && sortData) {
                                result = self._sortData(result);
                            }

                            if (result && ajaxInitialData) {
                                result.unshift(ajaxInitialData);
                            }

                            if (result && ajaxExcludeData) {
                                result = _.reject(result, function (r) { return _.contains(ajaxExcludeData, r.Value); });
                            }

                            if (result && result.length > 0) {
                                autoCompleteSharedData[dataKey] = result;
                                response(self._findItems(result, request.term), request.term);
                            }
                            else {
                                autoCompleteSharedData[dataKey] = {};
                            }
                        }, function (xhr, msg, e) {
                            $(".autocomplete-icon .autocomplete-loading", self.wrapper).hide();
                            $(".autocomplete-icon .autocomplete-error", self.wrapper).show();

                            autoCompleteSharedData[dataKey] = {};

                            if (a4)
                                a4.onAjaxPageMethodError(xhr, msg, e);
                        });
                    }
                    else {
                        response(self._findItems(autoCompleteSharedData[dataKey], request.term));
                    }
                }
            }

            return source;
        },
        _initializeTooltip: function () {
            var autocomplete = this.element;
            var options = this.options;
            var data = typeof options.data === "function" ? options.data() : options.data;
            if (!options.ajaxAction && autocomplete.attr("data-value")) {
                var item = _.find(data, function (e) { return e[options.valueProperty] == autocomplete.attr("data-value"); });

                if (item) {
                    if (options.tooltipData != null && _.isFunction(options.tooltipData)) {
                        options.tooltipData(autocomplete, null, item[options.tooltipProperty]);
                    }
                    else if (options.tooltipProperty != null) {
                        autocomplete.attr("title", item[options.tooltipProperty]);
                    }
                }
            }
        },
        _renderTooltip: function (item, tooltipElement) {
            var autocomplete = this.element;
            var menu = autocomplete.autocomplete("widget");
            var options = this.options;
            var tooltip = this.tooltip;
            var toolTipTop = $(tooltipElement).offset().top;

            if (!tooltip) {
                tooltip = $("<div />", { "class": "autocomplete-tooltip ui-front", "style": options.tooltipCustomStyle ? options.tooltipCustomStyle : ""});

                menu.parent().append(tooltip);

                this.tooltip = tooltip;
            }

            tooltip.show();

            tooltip.position({
                my: options.tooltipCustomPosition ? options.tooltipCustomPosition["my"] : "right top",
                at: options.tooltipCustomPosition ? options.tooltipCustomPosition["at"] : "left top",
                of: menu,
                collision: "flip"
            });

            if (options.tooltipCustomStyle) {
                $('.autocomplete-tooltip').css('top', toolTipTop + 'px');
            }

            this._hideTooltip();

            if (options.tooltipData && _.isFunction(options.tooltipData)) {
                this.tooltipTimer = window.setTimeout(function () {
                    var data = (options.tooltipProperty ? item[options.tooltipProperty] : item);
                    options.tooltipData(autocomplete, tooltip, data);
                }, 500);
            }
            else if (options.tooltipProperty && item[options.tooltipProperty]) {
                this.tooltipTimer = window.setTimeout(function () {
                    tooltip.html(item[options.tooltipProperty]).show();
                }, 500);
            }
        },
        _hideTooltip: function () {
            if (this.tooltipTimer) {
                window.clearTimeout(this.tooltipTimer);
            }

            if (this.tooltip) {
                this.tooltip.hide();
            }
        },
        _setOption: function (key, value) {
            var options = this.options;
            this._super(key, value);

            switch (key) {
                case "data":
                    var source = this._getSource();
                    this.element.autocomplete("option", "source", source);
                    this._resolveInitialValue();
                    break;
                case "ajaxAction":
                case "ajaxParams":
                    var source = this._getSource();
                    this.element.autocomplete("option", "source", source);
                    //this.clearValue();
                    break;
            }
        },
        _resolveInitialValue: function () {
            var self = this;
            var dataValue = this.element.attr("data-value");

            if (!dataValue && this.options.altValueField)
                dataValue = this.options.altValueField.val();

            var numericValue = parseInt(dataValue);

            if (this.element.val().length == 0) {
                if (dataValue && dataValue.length > 0) {
                    var data = this._getData();

                    if (this.options.multipleSelection) {
                        var values = dataValue.split(this.options.valueSeparator);

                        _.each(values, function (v) {
                            var item = self._getItemByVal(v, data);

                            if (item) {
                                $(".selected-items", self.wrapper).append(self._getAutoCompleteItemForMultiple(item));
                            }
                        });

                        this._updateMultipleCount();
                    }
                    else {
                        var item = this._getItemByVal(dataValue, data);

                        if (item)
                            this.element.val(item[this.options.labelProperty]);
                        else if (!this.element.val() && (isNaN(numericValue) || numericValue > 0))
                            this.element.val(dataValue);
                    }
                }

                if (this.element.val().length == 0 && this.options.required) {
                    var data = this._getData();

                    if (data) {
                        var firstItem = _.first(data);

                        if (firstItem) {
                            if (this.options.multipleSelection) {
                                $(".selected-items", this.wrapper).append(this._getAutoCompleteItemForMultiple(firstItem));

                                this._updateMultipleCount();

                                this._updateAltValueFieldForMultiple();
                            }
                            else {
                                this.element.val(firstItem[this.options.labelProperty]);

                                if (this.options.altValueField) {
                                    this.options.altValueField.val(firstItem[this.options.valueProperty]).trigger("change");
                                }
                            }

                            this._trigger("select", null, { item: firstItem });
                        }
                    }
                }
            }
        },
        _setModalDialogOptions: function () {
            var autocomplete = this.element;
            var parentWindow = a4.parent(autocomplete);
            var fancyBoxWrap = $(".fancybox-wrap", parentWindow.document);

            if (fancyBoxWrap.length > 0) {
                autocomplete.autocomplete("option", {
                    "appendTo": fancyBoxWrap,
                    "position": {
                        my: "left top",
                        using: function (pos, elements) {
                            var elementOffSet = elements.target.element.offset();
                            $(this).css("left", elementOffSet.left);
                            $(this).css("top", elementOffSet.top + elements.target.element.outerHeight());
                        }
                    }
                });

            }

            //Tests IE
            //this._updateAutoCompleteInstances();

            autocomplete.scrollParent().on("scroll", function () {
                autocomplete.autocomplete("close");
            });
        },
        _updateAutoCompleteInstances: function () {
            var autocomplete = this.element;
            var currentWindow = a4.getElementWindow(autocomplete);
            var topWindow = a4.top(autocomplete);

            if (!topWindow.autoCompletes) {
                topWindow.autoCompletes = {};
            }

            if (!topWindow.autoCompletes[currentWindow.name]) {
                topWindow.autoCompletes[currentWindow.name] = [];
            }

            topWindow.autoCompletes[currentWindow.name].push(this);
        },
        _initializeMultiple: function () {
            //Overloading method for multiple selection
            this._selectItem = this._selectItemForMultiple;

            var selectedItemsList = $("<ul />", { "class": "selected-items clearfix" });

            selectedItemsList.hide();

            if (this.options.displayMultipleSelectionAsList) {
                this.wrapper.addClass("list");
                this.wrapper.prepend(selectedItemsList);
            }
            else {
                //    var input = $("<li />", { "class": "input-item" }).append($(".autocomplete-input", this.wrapper));
                //    selectedItemsList.append(input);
                this.wrapper.append(selectedItemsList);
            }
        },
        _updateRendering: function () {
            var valueProperty = this.options.valueProperty;
            var labelProperty = this.options.labelProperty;
            var valueProperty = this.options.valueProperty;
            var descriptionProperty = this.options.descriptionProperty;
            var categoryProperty = this.options.categoryProperty;
            var displayDeleteItem = this.options.displayDeleteItem;
            var limitResults = this.options.limitResults;
            var renderItem = this.options.render.item;
            var limitResultsMessage = this._getLabel("LimitedResultsMessage");
            var instance = this.element.autocomplete("instance");
            var boxWidth = this.options.boxWidth;
            var regExp;

            if (renderItem) {
                instance._renderItem = function (ul, item) {
                    return $("<li>").data("ui-autocomplete-item", item).append(renderItem(item)).appendTo(ul);
                }
            }
            else {
                instance._renderItem = function (ul, item) {
                    var label = item[labelProperty] || item[valueProperty];

                    //Highlight matches
                    if (regExp && label) {
                        label = label.toString().replace(regExp, "<span class=\"highlighted-text\">$&</span>");
                    }

                    if (item[descriptionProperty]) {
                        label += " - " + item[descriptionProperty];
                    }

                    if (item[valueProperty] && a4.evaluateCondition(displayDeleteItem, item)) {
                        label += '<div class="actions">' + voxco.icons.getIcon("close", "h-deleteItem", { "Title": sharedResources.Delete }) + '</div>';
                    }

                    return $("<li>").data("ui-autocomplete-item", item).append(label).appendTo(ul);
                };
            }

            instance._renderMenu = function (ul, items) {
                //regExp = (this.previous != undefined && this.term != this.previous) ? new RegExp(this.term.replace(/[-\[\]{}()*+?.,\\^$|#\s]/g, "\\$&"), "gi") : null;
                regExp = new RegExp(this.term.replace(/[-\[\]{}()*+?.,\\^$|#\s]/g, "\\$&"), "gi");

                var renderItemsCount = Math.min(items.length, (limitResults || items.length));

                if (categoryProperty) {
                    var currentCategory = "";

                    for (var index = 0; index < renderItemsCount; index++) {
                        var item = items[index];

                        if (item[categoryProperty] != currentCategory) {
                            if (item[categoryProperty]) {
                                var categoryItem = $("<li />", { "class": "ui-autocomplete-category ui-menu-divider" }).append(item[categoryProperty]);
                                ul.append(categoryItem);
                            }

                            currentCategory = item[categoryProperty];
                        }

                        this._renderItemData(ul, item);
                    }
                }
                else {
                    for (var index = 0; index < renderItemsCount; index++) {
                        var item = items[index];

                        this._renderItemData(ul, item);
                    }
                }

                if (renderItemsCount != items.length) {
                    $("<li>", { "class": "autocomplete-message ui-menu-divider" }).append(limitResultsMessage.replace(/{limit}/g, renderItemsCount).replace(/{total}/g, items.length)).appendTo(ul);
                }
            };

            instance._resizeMenu = function () {
                var ul = this.menu.element;
                var width;

                if (boxWidth) {
                    width = boxWidth;
                }
                else {
                    width = $(this.element).closest(".autocomplete-input").width();

                    /*Hack to 1px hell - Suggestion box is off by 1px in these cases*/
                    if ($(this.element).closest(".modernEditor").length == 0 && (categoryProperty || displayDeleteItem)) {
                        width += 1;
                    }
                }

                ul.outerWidth(width);
            };
        },
        _createButton: function () {
            if (this.wrapper.find(".h-autocomplete-button").length == 0) {
                this.element.addClass("autocomplete");
                this.element.after(voxco.icons.getIcon("caret-down", "h-autocomplete-button", { Title: this._getLabel("SelectItem") }));
            }
        },
        _bindEvents: function () {
            var self = this;
            var autocomplete = this.element;
            var widget = autocomplete.autocomplete("widget");

            autocomplete.on("keypress", function (e) {
                code = (e.keyCode ? e.keyCode : e.which);

                // check has value, do not add empty
                if (code == 13 && autocomplete.val()) {
                    autocomplete.autocomplete("close");
                    self._selectItem();
                    e.preventDefault();
                }
            });

            this.wrapper.on("click", this.options.displayDropDownButton ? ".h-autocomplete-button:not(.disabled)" : "input", function (event) {
                // In IE 10 setting the placeholder field value trigger a blur event which make the autocomplete display itself on load
                // the current workout is to set the minlength at 1 during initialization and the reset it at the default value of 0.
                // once IE or jquery fix the issue this code could be removed.
                self.element.autocomplete("option", "minLength", 0);

                if (self.isOpen) {
                    self.element.autocomplete("close");
                }
                else {
                    $(this).trigger("blur");
                    self.element.autocomplete("search", "");
                    self.element.trigger("focus");
                }
            });

            if (this.options.displayDeleteItem) {
                widget.on("click", ".h-deleteItem", function (event) {
                    self.preventSelect = true;
                    var listItem = $(this).closest("li");
                    var item = listItem.data("ui-autocomplete-item");
                    self._trigger("deleteItem", event, { item: item });
                });
            }

            if (this.options.multipleSelection) {
                this.element.on("focus", function () {
                    $(this).val("");
                });

                this.wrapper.on("click", ".remove-item:not(.disabled)", function (event) {
                    var data = self._getData();
                    var valueProperty = self.options.valueProperty;
                    var removedItem = $(this).closest(".selected-item");
                    var item = _.find(data, function (i) { return i[valueProperty] == removedItem.attr("data-value"); });
                    removedItem.remove();
                    self._trigger("removeItem", event, { item: item });
                    self._trigger("change");
                    self._updateMultipleCount();
                    self._updateAltValueFieldForMultiple();

                    if (self.options.maxItems && self.options.maxItems > self.getSelectedItemsCount()) {
                        self.toggle(false, true);
                    }
                });
            }

            //Override default menufocus event of jquery autocomplete
            widget.off("menufocus").on("menufocus", function (event, ui) {
                if (self.isOpen && ui.item) {
                    var item = ui.item.data("ui-autocomplete-item");

                    if (self.options.tooltipProperty != null || self.options.tooltipData != null) {
                        self._renderTooltip(item, ui.item);
                    }

                    if (item && item[self.options.labelProperty]) {
                        autocomplete.val(item[self.options.labelProperty]);
                    }
                }
            });
        },
        _preloadData: function () {
            var self = this;
            var dataKey = this._getSourceDataKey();

            if (!autoCompleteSharedData[dataKey] && this.options.ajaxAction) {
                a4.callServerMethod(this.options.ajaxAction, this.options.ajaxParams, function (result) {
                    if (result && result.length > 0) {
                        autoCompleteSharedData[dataKey] = result;
                    }
                    else {
                        autoCompleteSharedData[dataKey] = {};
                    }
                }, function () {
                    autoCompleteSharedData[dataKey] = {};
                },
                    { "async": false });
            }

            return autoCompleteSharedData[dataKey];
        },
        _getData: function () {
            var data;

            if (this.options.data) {
                data = typeof this.options.data === "function" ? this.options.data() : this.options.data;
            }
            else {
                var dataKey = this._getSourceDataKey();
                data = autoCompleteSharedData[dataKey];

                if (!data || data.length == 0) {
                    data = this._preloadData();
                }
            }

            return data;
        },
        _sortData: function (data) {
            var categoryProperty = this.options.categoryProperty;
            var labelProperty = this.options.labelProperty;

            return _.sortBy(data, function (d) {
                return (d[categoryProperty] || "") + (d[labelProperty] || "");
            });
        },
        _getItemByVal: function (value, data) {
            var item;
            var valueProperty = this.options.valueProperty;
            var labelProperty = this.options.labelProperty;

            if (data && data.length > 0) {
                item = _.find(data, function (i) { return i[valueProperty] == value });
            }

            if (!item && !this.options.validateSelection) {
                item = {};
                item[valueProperty] = value;
                item[labelProperty] = value;
            }

            return item;
        },
        _findItems: function (autoCompleteData, term) {
            var self = this;
            var matcher = new RegExp($.ui.autocomplete.escapeRegex(term), "i");
            var labelProperty = this.options.labelProperty;
            var descriptionProperty = this.options.descriptionProperty;
            var categoryProperty = this.options.categoryProperty;
            var hideSelectedItems = this.options.hideSelectedItems;

            var data = typeof autoCompleteData === "function" ? autoCompleteData() : autoCompleteData;

            return _.filter(data, function (value) {
                return (!hideSelectedItems || !self._isSelected(value)) &&
                    (matcher.test(value[labelProperty])
                        || (value[descriptionProperty] && matcher.test(value[descriptionProperty]))
                        || (value[categoryProperty] && matcher.test(value[categoryProperty])));
            });
        },
        _getAutoCompleteItem: function (ui) {
            var item;
            var self = this;

            if (ui && ui.item) {
                item = ui.item;
            }
            else {
                var data = this._getData();
                var value = this.element.val();
                var regexp = new RegExp("^" + $.ui.autocomplete.escapeRegex(value) + "$", "i");
                var item = _.find(data, function (item) {
                    return item[self.options.labelProperty] != null ? item[self.options.labelProperty].toString().match(regexp) : false;
                });

                if (!item && !this.options.validateSelection) {
                    item = {};
                    item[this.options.valueProperty] = this.options.defaultValueWhenInvalid ? this.options.defaultValue : value;
                    item[this.options.labelProperty] = value;
                }
            }

            return item;
        },
        _selectItem: function (item) {
            var value;
            var label;

            if (!item) {
                var data = this._getData();

                if (data) {
                    item = this._getItemByVal(this.options.defaultValue, data);

                    if (!item && this.options.required)
                        item = _.first(data);
                }
            }

            if (item) {
                value = item[this.options.valueProperty];
                label = item[this.options.labelProperty];

                if (!label) label = value;
            }
            else {
                value = this.options.defaultValue;
                label = this.options.defaultLabel;
            }

            this.element.attr("data-value", value);
            this.element.val(label);

            //Update alternate field with the selected / typed value
            if (this.options.altValueField)
                this.options.altValueField.val(value).trigger("change");

            this._trigger("select", null, { item: item });
            this._trigger("change");
        },
        _selectItemForMultiple: function (item) {
            if (item && !this._isSelected(item)) {
                var customValidationPassed = this._customValidationForMultiSelect(item);
                if (customValidationPassed) {
                    var selectedItemsContainer = $(".selected-items", this.wrapper);
                    selectedItemsContainer.append(this._getAutoCompleteItemForMultiple(item));
                    selectedItemsContainer.scrollTop(selectedItemsContainer.get(0).scrollHeight);

                    this._updateMultipleCount();
                    this._updateAltValueFieldForMultiple();
                }
            }

            this.element.val("");
            this._trigger("select", null, { item: item });
            this._trigger("change");
        },
        _getAutoCompleteItemForMultiple: function (item) {
            var autoCompleteItem = $("<li />", { "class": "selected-item", "data-value": item[this.options.valueProperty] });

            var actions = $("<div />", { "class": "actions" });

            actions.append(voxco.icons.getIcon("close", "remove-item", { Title: this._getLabel("RemoveItem") }));

            if (this.options.render.selected) {
                autoCompleteItem.append(this.options.render.selected(item));
            }
            else {
                autoCompleteItem.append($("<span />", { "class": "item-label", "title": item[this.options.descriptionProperty] }).text(item[this.options.labelProperty]));
            }

            autoCompleteItem.append(actions);

            return autoCompleteItem;
        },
        _updateMultipleCount: function () {
            var itemCount = this.getSelectedItemsCount();
            var autocomplete = this.element;

            if (itemCount == 0) {
                var placeholder = this._getLabel("PlaceHolder");
                autocomplete.attr("placeholder", (placeholder ? placeholder : ""));
                $(".selected-items", this.wrapper).hide();
                autocomplete.removeClass("has-selected-items");
            }
            else {
                if (this.options.multipleSelection && this.options.displaySeparator) {
                    autocomplete.attr("placeholder", this.getSelectedItemDisplay());
                }
                else {
                    var label = itemCount == 1 ? this._getLabel("SelectedItem") : this._getLabel("SelectedItems");
                    autocomplete.attr("placeholder", label.replace(/{count}/g, itemCount));
                }

                $(".selected-items", this.wrapper).show();
                autocomplete.addClass("has-selected-items");
            }

            this._trigger("updateCount", null, { itemCount: itemCount });
        },
        _updateAltValueFieldForMultiple: function () {
            //Update alternate field with the selected / typed value
            if (this.options.altValueField) {
                var values = this.wrapper.find(".selected-item").map(function () {
                    return $(this).attr("data-value");
                }).get();

                this.options.altValueField.val(values.join(this.options.altValueSeperator)).trigger("change");
            }
        },
        _getLabel: function (key) {
            var text = undefined;

            if (this.options.resources[key]) {
                text = this.options.resources[key];
            }
            else if (autoCompleteResources && autoCompleteResources[key]) {
                text = autoCompleteResources[key];
            }

            return text;
        },
        _destroy: function () {
            $(".h-autocomplete-button", this.wrapper).remove();
            $(".autocomplete-icon", this.wrapper).remove();

            if (this.options.multipleSelection) {
                $(".selected-items", this.wrapper).remove();
            }

            if (!a4.ie() && this.options.appendToParent && this.element.closest(".modernEditor").length > 0 && a4.inIFrame(this.element)) {
                this.element.scrollParent().off("scroll");
            }

            this.element.unwrap().unwrap(); //Remove parent containers.
            this.element.removeClass("autocomplete");
            this.element.removeAttr("data-value");
            this.element.autocomplete("destroy");
        },
        clearValue: function () {
            this.element.removeAttr("data-value");

            if (this.options.multipleSelection) {
                $(".selected-item", this.wrapper).remove();
                this._updateMultipleCount();
                this._updateAltValueFieldForMultiple();
            }
            else {
                this.element.val(this.options.defaultLabel);

                if (this.options.altValueField)
                    this.options.altValueField.val(this.options.defaultValue).trigger("change");
            }

            if (this.options.maxItems)
                this.toggle(false, true);
        },
        getData: function () {
            return this._getData();
        },
        getValue: function (valueOnly) {
            var valueProperty = this.options.valueProperty;

            if (this.options.multipleSelection) {
                var values = this.wrapper.find(".selected-item").map(function () {
                    return $(this).attr("data-value");
                }).get();

                if (values && values.length > 0 && this.options.validateSelection && !valueOnly) {
                    var items = [];
                    var data = this._getData();

                    _.each(values, function (value) {
                        items.push(_.find(data, function (item) { return item[valueProperty] == value; }))
                    });

                    return items;
                }
                else {
                    return values;
                }
            }
            else {
                var value = this.element.attr("data-value");

                if (!value && this.options.altValueField)
                    value = this.options.altValueField.val();

                if (value && this.options.validateSelection && !valueOnly) {
                    var data = this._getData();
                    return _.find(data, function (item) { return item[valueProperty] == value; }) || null;
                }
                else {
                    return value;
                }
            }
        },
        setValue: function (item) {
            if (this.options.multipleSelection) {
                var data = this._getData();
                var self = this;

                _.each(item, function (i) {
                    self._selectItem(self._getItemByVal(i, data));
                });
            }
            else {
                if (!_.isObject(item)) {
                    var data = this._getData();
                    item = this._getItemByVal(item, data);
                }

                this._selectItem(item);
            }
        },
        setData: function (newData) {
            var dataKey = this._getSourceDataKey();
            autoCompleteSharedData[dataKey] = newData;
        },
        _isSelected: function (item) {
            var itemValue = item[this.options.valueProperty].toString().replace(/'/g, "\\'");

            if (this.options.multipleSelection) {
                return $(".selected-item[data-value='" + itemValue + "']", this.wrapper).length > 0;
            }
            else {
                return itemValue == this.element.attr("data-value");
            }
        },
        toggle: function (disabled, allowRemoveSelected) {
            this.element.autocomplete("option", "disabled", disabled);
            this.element.prop("disabled", disabled);
            this.element.prop("readonly", disabled);

            $(".h-autocomplete-button", this.wrapper).toggleClass("disabled", disabled);

            if (this.options.multipleSelection && !allowRemoveSelected) {
                $(".selected-item", this.wrapper).toggleClass("disabled", disabled);
                $(".selected-item .remove-item", this.wrapper).toggleClass("disabled", disabled);
            }
        },
        disable: function () {
            this.toggle(true);
        },
        enable: function () {
            this.toggle(false);
        },
        clearCache: function () {
            var dataKey = this._getSourceDataKey();
            autoCompleteSharedData[dataKey] = undefined;
        },
        getSelectedItemsCount: function () {
            return this.options.multipleSelection ? $(".selected-items .selected-item", this.wrapper).length : 1;
        },
        getSelectedItemDisplay: function () {
            var value = this.getValue();
            return value.join(this.options.displaySeparator);
        }

    });
}(jQuery));